﻿using System;
using System.Net;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Documents;
using System.Windows.Ink;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Animation;
using System.Windows.Shapes;

using System.Collections.Generic;

namespace iXTankenSimple
{
    public class InMemoryTankVorgangModelService: ITankvorgangModelService
    {

        private static List<TankVorgang> TankVorgangList = null;

        public IEnumerable<TankVorgang> GetTankVorgangList()
        {
            if (TankVorgangList == null)
            {
                TankVorgangList = new List<TankVorgang>{
                    new TankVorgang() {Kilometerstand = 48230.0, Datum = new DateTime(2010,3,10), Betrag=48.50, Menge=39.5, Anmerkung="Testtanke"},
                    new TankVorgang() {Kilometerstand = 48980.0, Datum = new DateTime(2010,4,2), Betrag= 52.80, Menge=35.6, Anmerkung="Diesltank"}
                };
            }
                
            return TankVorgangList;
        }

        public void AddNewTankVorgang(TankVorgang newTankVorgang)
        {
            if (TankVorgangList != null)
            {
                TankVorgangList.Add(newTankVorgang);
            }
        }
    }
}
